

#include <windows.h>
#define ULONG_PTR DWORD
#include<GdiPlus.h>

#include "mdpngvfw.h"


#pragma comment(lib, "gdiplus.lib")

// in windows explorer right-click on mdpngvfw.inf and install it

// for Gdiplus
static Gdiplus::GdiplusStartupInput gdiplusStartupInput;
ULONG_PTR gdiplusToken= NULL;

CLSID pngClsid;

DWORD g_dwInstCount= 0;


INT GetEncoderClsid(const WCHAR* format, CLSID* pClsid)  // helper function
{
   UINT  num = 0;          // number of image encoders
   UINT  size = 0;         // size of the image encoder array in bytes

	Gdiplus::ImageCodecInfo* pImageCodecInfo = NULL;

	Gdiplus::GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;  // Failure

   pImageCodecInfo = (Gdiplus::ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;  // Failure

	GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;  // Success
      }    
   }

   free(pImageCodecInfo);
   return -1;  // Failure
}

// def file
LRESULT WINAPI DriverProc( DWORD_PTR dwDriverId, HDRVR hDriver, UINT uMsg, 
	LPARAM lParam1, LPARAM lParam2) 
{
	MDPNGVFW * mdpngvfw = (MDPNGVFW*)dwDriverId;
	ICOPEN *icopen = (ICOPEN *)lParam2;

	switch(uMsg)
	{

	// nothing to do
	case DRV_INSTALL:
	case DRV_REMOVE:
	case DRV_DISABLE:
	case DRV_ENABLE:
	case DRV_LOAD:
	case DRV_FREE:
		return DRVCNF_OK;

	// not used
	case DRV_QUERYCONFIGURE:
	case DRV_CONFIGURE:
		return DRVCNF_CANCEL;

	case DRV_OPEN:
		if( g_dwInstCount == 0 )
		{
			CoInitialize(NULL);
			Gdiplus::GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);

			GetEncoderClsid(L"image/png", &pngClsid);
		}
		g_dwInstCount++;

		icopen = (ICOPEN *)lParam2;
			
		if (icopen != NULL && icopen->fccType != ICTYPE_VIDEO)
			return DRVCNF_CANCEL;
			
		mdpngvfw = (MDPNGVFW*)malloc(sizeof(MDPNGVFW));

		if (mdpngvfw == NULL)
		{
			if (icopen != NULL)
			{
				icopen->dwError = ICERR_MEMORY;
			}
			return 0;
		}
        
		// all to NULL
		memset(mdpngvfw, 0, sizeof(MDPNGVFW));
            
		StgCreateDocfile(
				NULL,
				STGM_READWRITE|STGM_CREATE|STGM_SHARE_EXCLUSIVE|STGM_DELETEONRELEASE, 
				0, 
				&mdpngvfw->pIStorage);

		mdpngvfw->pIStorage->CreateStream(
				L"StreamImage",
				STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
				0,
				0,
				&mdpngvfw->pIStream);


		if (icopen != NULL)
			icopen->dwError = ICERR_OK;
		
		// return address of struct
		return (LRESULT)mdpngvfw;

	case DRV_CLOSE:

		g_dwInstCount--;
		if( g_dwInstCount == 0 )
		{
			CoUninitialize();
			Gdiplus::GdiplusShutdown(gdiplusToken);
		}
				

		mdpngvfw->pIStream->Release(); 
		mdpngvfw->pIStorage->Release();

		free(mdpngvfw);
		return DRVCNF_OK;


	// nothing to do
	case ICM_GETSTATE:
	case ICM_SETSTATE:
	case ICM_GET:
	case ICM_SET:
		return ICERR_OK;

	// not used
	case ICM_GETDEFAULTQUALITY:
	case ICM_GETQUALITY:
	case ICM_SETQUALITY:
	case ICM_GETBUFFERSWANTED:
	case ICM_GETDEFAULTKEYFRAMERATE:
	case ICM_CONFIGURE:
	case ICM_DECOMPRESS_GET_PALETTE:
	case ICM_DECOMPRESS_SET_PALETTE:
	case ICM_DECOMPRESSEX_QUERY:
	case ICM_DECOMPRESSEX_BEGIN:
	case ICM_DECOMPRESSEX_END:
	case ICM_DECOMPRESSEX:
		return ICERR_UNSUPPORTED;

	case ICM_GETINFO:
		if (lParam1 && lParam2 >= sizeof(ICINFO)) {
			ICINFO *icinfo = (ICINFO *)lParam1;

			icinfo->fccType = ICTYPE_VIDEO;
			icinfo->fccHandler = FOURCC_PNG;
			icinfo->dwFlags =
				VIDCF_FASTTEMPORALC |
				VIDCF_FASTTEMPORALD |
				VIDCF_COMPRESSFRAMES;

			icinfo->dwVersion = 0;

			icinfo->dwVersionICM = ICVERSION;
			
			wcscpy_s(icinfo->szName, sizeof(icinfo->szName), L"MDPNGVFW"); 
			wcscpy_s(icinfo->szDescription, sizeof(icinfo->szDescription), L"Simple PNG Codec");
						
			return lParam2;
		}

		return 0;
		
	case ICM_ABOUT:
		if (lParam1 != -1)
			MessageBox( (HWND)lParam1, L"Simple PNG Codec", L"MDPNGVFW", MB_OK);
		return ICERR_OK;

	
	// compression
	case ICM_COMPRESS_QUERY:
		return compress_query( (BITMAPINFO *)lParam1, (BITMAPINFO *)lParam2);

	case ICM_COMPRESS_GET_FORMAT:
		return compress_get_format( (BITMAPINFO *)lParam1, (BITMAPINFO *)lParam2);

	case ICM_COMPRESS_GET_SIZE:
		return compress_get_size( (BITMAPINFO *)lParam1, (BITMAPINFO *)lParam2);

	case ICM_COMPRESS_FRAMES_INFO:
	case ICM_COMPRESS_BEGIN:
	case ICM_COMPRESS_END:
		return ICERR_OK;

	case ICM_COMPRESS:
		return compress(mdpngvfw, (ICCOMPRESS *)lParam1);

	// decompression
	case ICM_DECOMPRESS_BEGIN:
	case ICM_DECOMPRESS_END:
		return ICERR_OK;

	case ICM_DECOMPRESS_QUERY:
		return decompress_query( (BITMAPINFO*)lParam1, (BITMAPINFO*)lParam2);

	case ICM_DECOMPRESS_GET_FORMAT:
		return decompress_get_format( (BITMAPINFO*)lParam1, (BITMAPINFO*)lParam2);

	case ICM_DECOMPRESS:
		return decompress(mdpngvfw, (ICDECOMPRESS *)lParam1);

	// everything else
	default:
		return ICERR_UNSUPPORTED;
	}
}

// def file
void WINAPI Configure(HWND hwnd, HINSTANCE hinst, LPTSTR lpCmdLine, int nCmdShow)
{
	MessageBox( hwnd, L"Simple PNG Codec", L"MDPNGVFW", MB_OK);
}

// not needed, GdiplusShutdown shouldn't be called here
/*INT_PTR WINAPI DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
    return TRUE;
}*/
