
#include <windows.h>
#define ULONG_PTR DWORD
#include<GdiPlus.h>

#include "mdpngvfw.h"
#include"lodepng.h"

// declared in Driverproc.cpp
extern CLSID pngClsid;

/////////////////////////////////////////////////////
//
// Encoding
//
LRESULT compress_query( BITMAPINFO * lpbiInput, BITMAPINFO * lpbiOutput)
{
	BITMAPINFOHEADER *inhdr = &lpbiInput->bmiHeader;
	BITMAPINFOHEADER *outhdr = &lpbiOutput->bmiHeader;

	// makes no sense?
	if (lpbiOutput == NULL) 
		return ICERR_OK;

	if( inhdr->biBitCount != 8 && inhdr->biBitCount != 24 &&
		inhdr->biBitCount != 32 )
		return ICERR_BADFORMAT;

	if (inhdr->biWidth != outhdr->biWidth || inhdr->biHeight != outhdr->biHeight ||
		outhdr->biCompression != FOURCC_PNG)
		return ICERR_BADFORMAT;

	return ICERR_OK;
}


LRESULT compress_get_format( BITMAPINFO * lpbiInput, BITMAPINFO * lpbiOutput)
{
	BITMAPINFOHEADER *inhdr = &lpbiInput->bmiHeader;
	BITMAPINFOHEADER *outhdr = &lpbiOutput->bmiHeader;

	if (lpbiOutput == NULL) 
	{
		if( inhdr->biBitCount == 8 )
			return ( 1024 + sizeof(BITMAPINFOHEADER));

		return sizeof(BITMAPINFOHEADER);
	}

	if( inhdr->biBitCount != 8 && inhdr->biBitCount != 16 &&
		inhdr->biBitCount != 24 && inhdr->biBitCount != 32 )
		return ICERR_BADFORMAT;

	// copy all, same bitdepth and size
	memcpy(outhdr, inhdr, sizeof(BITMAPINFOHEADER));
	outhdr->biSize = sizeof(BITMAPINFOHEADER);
	// PNG is never larger then the BMP, isn't it?
	outhdr->biSizeImage = compress_get_size( lpbiInput, lpbiOutput);
	outhdr->biXPelsPerMeter = 0;
	outhdr->biYPelsPerMeter = 0;
	outhdr->biClrUsed = 0;
	outhdr->biClrImportant = 0;
	outhdr->biCompression = FOURCC_PNG;

	if( outhdr->biBitCount == 8 )
	{
		BYTE *pTable= (BYTE*)outhdr;

		for( int i=0; i<256; i++)
		{
			pTable[ sizeof(BITMAPINFOHEADER) + i*4]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+1]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+2]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+3]= 0;
		}
	}
	
	return ICERR_OK;
}

LRESULT compress_get_size( BITMAPINFO * lpbiInput, BITMAPINFO * lpbiOutput)
{
	// bigger then the origin, or can't PNG really never be bigger?
	return 2*lpbiInput->bmiHeader.biSizeImage;
}

// create gdiplus::Bitmap from BMP, save to stream
LRESULT compress(MDPNGVFW *mdpngvfw, ICCOMPRESS * icc)
{
	BITMAPINFOHEADER * inhdr = icc->lpbiInput;
	BITMAPINFOHEADER * outhdr = icc->lpbiOutput;

	Gdiplus::PixelFormat pixFormat= PixelFormat24bppRGB;

	if( inhdr->biBitCount == 8 )
		pixFormat= PixelFormat8bppIndexed;

	if( inhdr->biBitCount == 16 )
		pixFormat= PixelFormat16bppGrayScale;

	if( inhdr->biBitCount == 32 )
		pixFormat= PixelFormat32bppARGB;

	// stride, or WidthStep, is always biSizeImage/biHeight
	Gdiplus::Bitmap bitmap( (INT)inhdr->biWidth, (INT)inhdr->biHeight, (INT)inhdr->biSizeImage/inhdr->biHeight, pixFormat, (BYTE*)icc->lpInput);
	UINT width= bitmap.GetWidth();
	UINT height= bitmap.GetHeight();

	if( width != (UINT)inhdr->biWidth || height != (UINT)inhdr->biHeight )
		return ICERR_ERROR;
	
	// an den Anfang
	LARGE_INTEGER li;
	li.QuadPart= 0;

	mdpngvfw->pIStream->Seek( li, STREAM_SEEK_SET, NULL);

	Gdiplus::Status status= bitmap.Save( mdpngvfw->pIStream, &pngClsid);
	if( status != Gdiplus::Ok )
		return ICERR_ERROR;

	mdpngvfw->pIStream->Seek( li, STREAM_SEEK_SET, NULL);

	BYTE bBuf[100];
	ULONG ulRead= 0;
	HRESULT hr= mdpngvfw->pIStream->Read( bBuf, 100, &ulRead);
	if( hr != S_OK )
		return ICERR_ERROR;

	ULONG uPos= 0;
	while( hr == S_OK && ulRead > 0 )
	{
		BYTE *pPtr= (BYTE*)icc->lpOutput;
		pPtr += uPos;

		memcpy( pPtr, bBuf, ulRead);
		uPos += ulRead;

		ulRead= 0;
		hr= mdpngvfw->pIStream->Read( bBuf, 100, &ulRead);
		if( hr != S_OK )
			return ICERR_ERROR;
	};

	outhdr->biSizeImage= uPos;
	
	return ICERR_OK;

	// works with lodepng, but is very slow
	/*unsigned char *pOut;
	size_t sizeOut;
	unsigned res;

	res= lodepng_encode_memory( &pOut, &sizeOut,
		(const unsigned char*)icc->lpInput, inhdr->biWidth, inhdr->biHeight,
                               LCT_GREY, 8);

	outhdr->biSizeImage= sizeOut;
	*icc->lpdwFlags = AVIIF_KEYFRAME;

	memcpy( icc->lpOutput, pOut, sizeOut);

	free( pOut);

	return ICERR_OK;*/
}

///////////////////////////////////////////////////////////
//
// Decoding
//
LRESULT decompress_query( BITMAPINFO *lpbiInput, BITMAPINFO *lpbiOutput )
{
	BITMAPINFOHEADER *inhdr = &lpbiInput->bmiHeader;
	BITMAPINFOHEADER *outhdr = &lpbiOutput->bmiHeader;
	
	if( lpbiInput == NULL ) 
		return ICERR_ERROR;

	if( inhdr->biCompression != FOURCC_PNG )
		return ICERR_BADFORMAT;

	if( lpbiOutput == NULL ) 
		return ICERR_OK;

	if (inhdr->biWidth != outhdr->biWidth ||
		inhdr->biHeight != outhdr->biHeight ) 
		return ICERR_BADFORMAT;

	return ICERR_OK;
}


LRESULT decompress_get_format( BITMAPINFO * lpbiInput, BITMAPINFO * lpbiOutput)
{
	BITMAPINFOHEADER * inhdr = &lpbiInput->bmiHeader;
	BITMAPINFOHEADER * outhdr = &lpbiOutput->bmiHeader;

	if (lpbiOutput == NULL)
	{
		if( inhdr->biBitCount == 8 )
			return (1024+sizeof(BITMAPINFOHEADER));

		return sizeof(BITMAPINFOHEADER);
	}

	outhdr->biSize = sizeof(BITMAPINFOHEADER);
	outhdr->biWidth = inhdr->biWidth;
	outhdr->biHeight = inhdr->biHeight;
	outhdr->biPlanes = 1;
	outhdr->biBitCount = inhdr->biBitCount;
	outhdr->biCompression = BI_RGB;
	outhdr->biSizeImage = outhdr->biHeight * BMP_WIDTHSTEP(outhdr->biWidth, outhdr->biBitCount);

	outhdr->biXPelsPerMeter = 0;
	outhdr->biYPelsPerMeter = 0;
	outhdr->biClrUsed = 0;
	outhdr->biClrImportant = 0;

	if( inhdr->biBitCount == 8 )
	{
		BYTE *pTable= (BYTE*)outhdr;

		for( int i=0; i<256; i++)
		{
			pTable[ sizeof(BITMAPINFOHEADER) + i*4]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+1]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+2]= i;
			pTable[ sizeof(BITMAPINFOHEADER) + i*4+3]= 0;
		}
	}

	return ICERR_OK;
}

LRESULT decompress(MDPNGVFW * codec, ICDECOMPRESS * icd)
{
	HANDLE hBuffer= ::GlobalAlloc(GMEM_MOVEABLE, icd->lpbiInput->biSizeImage);
	if (!hBuffer)
		return FALSE;

	void* pBuffer= ::GlobalLock(hBuffer);
	if (!pBuffer)
	{
		::GlobalFree(hBuffer);
		return FALSE;
	}

	memcpy( pBuffer, (const void*)icd->lpInput, icd->lpbiInput->biSizeImage);

	IStream* pStream = NULL;
	Gdiplus::Bitmap *pBitmap= NULL;

	if (::CreateStreamOnHGlobal(hBuffer, TRUE, &pStream) == S_OK)
	{
		pBitmap = Gdiplus::Bitmap::FromStream(pStream, TRUE);
		Gdiplus::Status stat= pBitmap->GetLastStatus();
		pStream->Release();
	}

	BOOL bRet= FALSE;

	
	// Bild vorhanden? und sinnvoll
	if( pBitmap != NULL && pBitmap->GetWidth() > 0 &&  pBitmap->GetHeight() > 0 )
	{
		Gdiplus::Rect rect(0, 0, pBitmap->GetWidth(), pBitmap->GetHeight());
		Gdiplus::BitmapData	bData;

		if( pBitmap->LockBits( &rect, Gdiplus::ImageLockModeRead|Gdiplus::ImageLockModeWrite,
			pBitmap->GetPixelFormat(), &bData) == Gdiplus::Ok )
		{
			int iSrcStride= bData.Stride;
			int iDstStride= BMP_WIDTHSTEP(icd->lpbiOutput->biWidth, icd->lpbiOutput->biBitCount);
			int iMemCopy= min( iSrcStride, iDstStride);

			BYTE *pSrc= (BYTE*)bData.Scan0;
			BYTE *pDst= (BYTE*)icd->lpOutput;

			for( DWORD i=0; i<bData.Height; i++)
			{
				memcpy( pDst, pSrc, iMemCopy);

				pSrc += iSrcStride;
				pDst += iDstStride;
			}

		}// LockBits

	}// pBitmap != NULL

	Gdiplus::ImageType type= pBitmap->GetType();
	UINT uiWidth= pBitmap->GetWidth();

	// aufrumen
	delete pBitmap;
	GlobalUnlock( hBuffer);
	GlobalFree( hBuffer);

	// works with lodepng, but is very slow
	/*unsigned res;
	unsigned char *pOut;
	unsigned w,h;

	icd->lpbiOutput= icd->lpbiInput;

	res= lodepng_decode_memory(&pOut, &w, &h,
		(const unsigned char*)icd->lpInput, icd->lpbiInput->biSizeImage,
                               LCT_RGB, 8);

	icd->lpbiOutput->biCompression= BI_RGB;
	icd->lpbiOutput->biSizeImage= icd->lpbiInput->biWidth*icd->lpbiInput->biHeight*3;
	memcpy( icd->lpOutput, pOut, icd->lpbiOutput->biSizeImage);

	free( pOut);*/

	return ICERR_OK;
}

